#include "c4d_commandplugin.h"
#include "c4d_memory.h"
#include "c4d_basebitmap.h"
#include "c4d_file.h"
#include "c4d_general.h"
#include "c4d_gui.h"

Bool CommandData::Execute(BaseDocument *doc)
{
	return TRUE;
}

LONG CommandData::GetState(BaseDocument *doc)
{
	return CMD_ENABLED;
}

Bool CommandData::RestoreLayout(void *secret)
{
	return TRUE;
}

void CommandData::Message(const BaseContainer &msg)
{
}

Bool RegisterCommandPlugin(LONG id, const String &str, LONG info, const String &help, CommandData *dat)
{
	return RegisterCommandPlugin(id,str,info,NULL,help,dat);
}

Bool RegisterCommandPlugin(LONG id, const String &str, LONG info, String iconname, const String &help, CommandData *dat)
{
	if (!dat) return FALSE;

	Bool ok=FALSE;

	AutoAlloc<BaseBitmap> icon;

	if (icon && icon->Init(GeGetPluginPath()+String("res")+iconname)==IMAGE_OK)
		ok=RegisterCommandPlugin(id,str,info,icon,help,dat);

	return ok;
}

Bool RegisterCommandPlugin(LONG id, const String &str, LONG info, BaseBitmap *icon, const String &help, CommandData *dat)
{
	if (!dat) return FALSE;

	COMMANDPLUGIN np;
	ClearMem(&np,sizeof(np));

	np.adr						= dat;
	np.help						= (String*)&help;
	np.command_icon		= icon;
	np.info						= info;
	np.Destructor			= &CommandData::Destructor;
	np.Execute				= &CommandData::Execute;
	np.GetState				= &CommandData::GetState;
	np.RestoreLayout	= &CommandData::RestoreLayout;
	np.Message				= &CommandData::Message;

	return GeRegisterPlugin(C4DPL_COMMAND,id,str,&np,sizeof(np));
}
